#!/usr/bin/python3
"""Upotreba ./validate.py test/*.in*"""

import string


def check(lines):
    nl = []   # ispravno formatirane linije

    n = int(lines[0])
    k = int(lines[1])
    t = int(lines[2])
    assert 1 <= n <= 100, "n kriv"
    assert 1 <= k <= n, "k kriv"
    assert 1 <= t <= 10, "t kriv"
    nl.append("{}\n".format(n))
    nl.append("{}\n".format(k))
    nl.append("{}\n".format(t))

    for i in range(n):
        lst = list(map(int, lines[3 + i].split()))
        for x in lst:
            assert 1 <= x <= 100, "broj krivi"

        assert len(lst) == 7 * t, "nema 7*t brojeva"
        nl.append("{}\n".format(' '.join(str(x) for x in lst)))

    o = list(map(int, lines[3 + n].split()))
    assert len(o) == k, "nema k brojeva"

    for x in o:
        assert 1 <= x <= n, "oi krivi"

    nl.append("{}\n".format(' '.join(str(x) for x in o)))

    assert lines == nl, "Krivi format (%s vs %s)" % (lines, nl)
    assert lines[-1][-1] == "\n", "Zadnji red ne zavrsava sa \\n"
    return n, k, t


# Ocekivani clusteri! Ovo vjerojatno zelis promijeniti!
expected_clusters = {'normalni': 10}


def what_cluster(data):
    n, k, t = data
    # na temelju povratne informacije iz check(lines)
    # zakljucuje za TP u kojoj je bodovnoj sekciji
    return 'normalni'


################### Zadatak-specifican kod iznad ove linije #########################

import sys
import glob
import hashlib


def group_in_batches(files):
    # mnozenje.in.1a, mnozenje.in.1b sprema u isti batch

    files.sort()
    B = []
    for f in files:
        if f[-1].islower() and len(B) > 0 and f[:-1] == B[-1][-1][:-1]:
            B[-1].append(f)
        else:
            B.append([f])
    return B


if __name__ == "__main__":
    f = []
    for pattern in sys.argv[1:]:
        for filename in glob.glob(pattern):
            f.append(filename)

    bc = []
    for batch in group_in_batches(f):
        if 'dummy' not in batch[0]:
            bc.append([])
        for filename in batch:
            print("{}: ".format(filename), end="")
            try:
                lines = open(filename).readlines()
                summary = check(lines)
                c = what_cluster(summary)
                if 'dummy' not in batch[0]:
                    bc[-1].append(c)
            except Exception as e:
                print("Greska!", e)
                raise
            else:
                print("Sve ok! (cluster {}, summary = {})".format(c, summary))

    clusters = {}
    for b in bc:
        for c in b:
            assert c == b[0], "Ima razlicitih cluster-a unutar batcha"
        if not b[0] in clusters:
            clusters[b[0]] = 0
        clusters[b[0]] += 1

    assert clusters == expected_clusters, "Kriva raspodjela clustera ({} vs {})".format(clusters, expected_clusters)

    # Buda test - provjeri duplikate
    hashes = set(hashlib.sha1(open(x, 'rb').read()).hexdigest() for x in f)
    assert len(hashes) == len(f), "Ima duplikata!"
